<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nik', 'full_name', 'user_id', 'department_id', 'position_id', 'date_joined', 'date_end', 'gender', 'date_birth');

	public function department()
	{
		return $this->hasOne('App\Model\Department');
	}

}