<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('price', 'user_id', 'quantity', 'name', 'description', 'category_id');

	public function user()
	{
		return $this->belongsTo('app\User');
	}

	public function category()
	{
		return $this->belongsTo('app\Category');
	}

}