<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitiesTable extends Migration {

	public function up()
	{
		Schema::create('cities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->bigInteger('state_id')->unsigned()->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->string('code')->nullable();
			$table->text('featured_image');
		});
	}

	public function down()
	{
		Schema::drop('cities');
	}
}