<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pages_widget', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages_widget', function(Blueprint $table) {
			$table->foreign('widget_id')->references('id')->on('widgets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('widget_layouts', function(Blueprint $table) {
			$table->foreign('widget_id')->references('id')->on('widgets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages_widget_content', function(Blueprint $table) {
			$table->foreign('pages_widget_id')->references('id')->on('pages_widget')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages_widget_content', function(Blueprint $table) {
			$table->foreign('widget_layouts_id')->references('id')->on('widget_layouts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('pages_widget', function(Blueprint $table) {
			$table->dropForeign('pages_widget_page_id_foreign');
		});
		Schema::table('pages_widget', function(Blueprint $table) {
			$table->dropForeign('pages_widget_widget_id_foreign');
		});
		Schema::table('widget_layouts', function(Blueprint $table) {
			$table->dropForeign('widget_layouts_widget_id_foreign');
		});
		Schema::table('pages_widget_content', function(Blueprint $table) {
			$table->dropForeign('pages_widget_content_pages_widget_id_foreign');
		});
		Schema::table('pages_widget_content', function(Blueprint $table) {
			$table->dropForeign('pages_widget_content_widget_layouts_id_foreign');
		});
	}
}