<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTutorsTable extends Migration {

	public function up()
	{
		Schema::create('tutors', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->nullable()->index();
			$table->uuid('uuid_user');
			$table->date('dob')->nullable();
			$table->string('sex', 10)->nullable();
			$table->decimal('rating', 8,2)->nullable();
			$table->decimal('hourly_rate', 8,2)->nullable();
			$table->tinyInteger('years_of_experience');
			$table->string('education_degree', 255)->nullable();
			$table->text('about')->nullable();
			$table->integer('status')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tutors');
	}
}