<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('Tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('subject', 600);
			$table->datetime('closedDate')->nullable();
			$table->integer('statusid')->unsigned();
			$table->integer('techid')->unsigned();
			$table->time('timeWorked');
			$table->string('requestorId', 600);
			$table->string('requestorEmail', 600);
			$table->integer('queueId')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Tickets');
	}
}