<?php

namespace TicketTracker;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'Tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function status()
    {
        return $this->hasOne('Status', 'statusid');
    }

    public function comments()
    {
        return $this->hasMany('Comment', 'ticketid');
    }

    public function tags()
    {
        return $this->belongsToMany('Tag');
    }

    public function tech()
    {
        return $this->belongsTo('Tech', 'techid');
    }

    public function requestor()
    {
        return $this->hasOne('Requestor', 'requestorid');
    }

    public function queue()
    {
        return $this->belongsTo('Queue', 'queueId');
    }

}