<?php

namespace TicketTracker;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'Comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ticket()
	{
		return $this->belongsTo('Ticket', 'ticketid');
	}

}