<?php

namespace TicketTracker;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Queue extends Eloquent {

	protected $table = 'Queues';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tickets()
	{
		return $this->hasMany('TicketTracker\Ticket', 'queueId');
	}

}