<?php

namespace TicketTracker;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'Tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->hasOne('Status', 'statusid');
	}

	public function comments()
	{
		return $this->hasMany('Comment', 'ticketid');
	}

	public function tags()
	{
		return $this->belongsToMany('Tag');
	}

	public function tech()
	{
		return $this->belongsTo('Tech', 'techid');
	}

	public function requestor()
	{
		return $this->hasOne('Requestor', 'requestorid');
	}

	public function queue()
	{
		return $this->belongsTo('Queue', 'queueId');
	}

}