<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSessionsTable extends Migration {

	public function up()
	{
		Schema::create('sessions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('therapist_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->datetimeTz('starts_at');
			$table->datetimeTz('ends_at');
			$table->enum('status', array('confirmed', 'pending', 'rescheduling', 'cancelled'));
			$table->integer('length')->unsigned();
			$table->integer('location_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('sessions');
	}
}