<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('location_type_id')->references('id')->on('location_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profile_image_approvals', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plans_features', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plans_features', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('features')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_plans', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_plans', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('therapist_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('therapy_categories', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_locations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_session_type_prices', function(Blueprint $table) {
			$table->foreign('session_type_id')->references('id')->on('therapy_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_session_type_prices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('therapist_packages', function(Blueprint $table) {
			$table->foreign('therapy_type_id')->references('id')->on('therapy_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('therapist_packages', function(Blueprint $table) {
			$table->foreign('therapist_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('therapist_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('users_locations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('session_refunds', function(Blueprint $table) {
			$table->foreign('session_id')->references('id')->on('sessions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_location_type_id_foreign');
		});
		Schema::table('profile_image_approvals', function(Blueprint $table) {
			$table->dropForeign('profile_image_approvals_user_id_foreign');
		});
		Schema::table('plans_features', function(Blueprint $table) {
			$table->dropForeign('plans_features_plan_id_foreign');
		});
		Schema::table('plans_features', function(Blueprint $table) {
			$table->dropForeign('plans_features_feature_id_foreign');
		});
		Schema::table('users_plans', function(Blueprint $table) {
			$table->dropForeign('users_plans_user_id_foreign');
		});
		Schema::table('users_plans', function(Blueprint $table) {
			$table->dropForeign('users_plans_plan_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_patient_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_therapist_id_foreign');
		});
		Schema::table('therapy_categories', function(Blueprint $table) {
			$table->dropForeign('therapy_categories_created_by_foreign');
		});
		Schema::table('users_locations', function(Blueprint $table) {
			$table->dropForeign('users_locations_user_id_foreign');
		});
		Schema::table('users_session_type_prices', function(Blueprint $table) {
			$table->dropForeign('users_session_type_prices_session_type_id_foreign');
		});
		Schema::table('users_session_type_prices', function(Blueprint $table) {
			$table->dropForeign('users_session_type_prices_user_id_foreign');
		});
		Schema::table('therapist_packages', function(Blueprint $table) {
			$table->dropForeign('therapist_packages_therapy_type_id_foreign');
		});
		Schema::table('therapist_packages', function(Blueprint $table) {
			$table->dropForeign('therapist_packages_therapist_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_therapist_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_patient_id_foreign');
		});
		Schema::table('sessions', function(Blueprint $table) {
			$table->dropForeign('sessions_location_id_foreign');
		});
		Schema::table('bank_accounts', function(Blueprint $table) {
			$table->dropForeign('bank_accounts_user_id_foreign');
		});
		Schema::table('session_refunds', function(Blueprint $table) {
			$table->dropForeign('session_refunds_session_id_foreign');
		});
	}
}