<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plans extends Model 
{

    protected $table = 'plans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('price_monthly', 'price_yearly');
    protected $visible = array('price_monthly', 'price_yearly');

    public function features()
    {
        return $this->hasManyThrough('Features', 'PlansFeatures');
    }

}