<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TherapistPackages extends Model 
{

    protected $table = 'therapist_packages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'therapy_type_id', 'number_of_sessions', 'price', 'therapist_id');
    protected $visible = array('name', 'number_of_sessions', 'price');

    public function session()
    {
        return $this->hasOne('TherapyTypes', 'therapy_type_id', 'id');
    }

}