<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TherapyCategories extends Model 
{

    protected $table = 'therapy_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'slug', 'created_by', 'active');
    protected $visible = array('name', 'slug', 'active');

    public function user()
    {
        return $this->hasOne('Users', 'created_by', 'id');
    }

}