<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('patient_id')->unsigned();
			$table->integer('therapist_id')->unsigned();
			$table->text('text')->nullable();
			$table->smallInteger('rate_count')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}