<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersPlansTable extends Migration {

	public function up()
	{
		Schema::create('users_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->datetimeTz('expires_on');
			$table->enum('plan_type', array('monthly', 'yearly'));
		});
	}

	public function down()
	{
		Schema::drop('users_plans');
	}
}