<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfileImageApprovalsTable extends Migration {

	public function up()
	{
		Schema::create('profile_image_approvals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->enum('status', array('pending', 'approved', 'denied'));
			$table->text('image_url')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profile_image_approvals');
	}
}