<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BankAccounts extends Eloquent {

	protected $table = 'bank_accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('beneficiary_name', 'iban', 'bank_account_number', 'swift_code', 'user_id');
	protected $visible = array('beneficiary_name', 'iban', 'bank_account_number', 'swift_code');

	public function owner()
	{
		return $this->belongsTo('Users', 'user_id', 'id');
	}

}