<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TherapyCategories extends Eloquent {

	protected $table = 'therapy_categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slug', 'created_by', 'active');
	protected $visible = array('name', 'slug', 'active');

	public function user()
	{
		return $this->hasOne('Users', 'created_by', 'id');
	}

}