<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('dt_id', 'name', 'email', 'password', 'telephone', 'address', 'city', 'country', 'postal_code', 'website', 'birth_date', 'active', 'email_verified_at', 'location_type_id', 'wallet_amount');
	protected $visible = array('dt_id', 'name', 'email', 'password', 'telephone', 'address', 'city', 'country', 'postal_code', 'website', 'birth_date', 'active', 'email_verified_at', 'location_type_id', 'wallet_amount');

	public function role()
	{
		return $this->hasOne('Roles', 'id', 'role_id');
	}

	public function data()
	{
		return $this->hasMany('UsersMeta');
	}

	public function plan()
	{
		return $this->hasOne('UsersPlans', 'id', 'user_id');
	}

	public function reviews()
	{
		return $this->hasMany('Reviews', 'id', 'therapist_id');
	}

	public function category_suggestions()
	{
		return $this->hasMany('Roles', 'id', 'created_by');
	}

	public function location_type()
	{
		return $this->hasOne('LocationTypes', 'location_type', 'id');
	}

	public function locations()
	{
		return $this->hasMany('UsersLocations', 'id', 'user_id');
	}

	public function packages()
	{
		return $this->hasMany('TherapistPackages', 'id', 'therapist_id');
	}

	public function therapies()
	{
		return $this->hasMany('Sessions', 'id', 'patient_id');
	}

	public function sessions()
	{
		return $this->hasMany('Users', 'id', 'therapist_id');
	}

	public function bankAccount()
	{
		return $this->hasOne('BankAccounts', 'id', 'user_id');
	}

}