<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTherapistPackagesTable extends Migration {

	public function up()
	{
		Schema::create('therapist_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->integer('therapy_type_id')->unsigned();
			$table->integer('number_of_sessions')->unsigned();
			$table->decimal('price', 8,2);
			$table->integer('therapist_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('therapist_packages');
	}
}