<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid')->unique();
			$table->bigInteger('user_id')->unsigned();
			$table->string('websitename');
			$table->string('url');
			$table->integer('industry');
			$table->longText('description')->nullable();
			$table->integer('language')->nullable();
			$table->integer('country');
			$table->string('brandname')->nullable();
			$table->string('slogan')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->string('address')->nullable();
			$table->string('facebookurl')->nullable();
			$table->string('twitterurl')->nullable();
			$table->string('instagramurl')->nullable();
			$table->string('youtubeurl')->nullable();
			$table->longText('wordsblacklist')->nullable();
			$table->integer('tone')->nullable();
			$table->integer('pointofview')->nullable();
			$table->longText('crawlerexclude')->nullable();
			$table->longText('crawlerinclude')->nullable();
			$table->string('gscauthtoken')->nullable();
			$table->string('gscrefreshtoken')->nullable();
			$table->integer('pagescount');
			$table->integer('status');
			$table->string('wpapikey')->nullable();
			$table->longText('automations');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}