<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('keywords', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('optimizations', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activitylogs', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('activitylogs', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sites', function(Blueprint $table) {
			$table->dropForeign('sites_user_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_site_id_foreign');
		});
		Schema::table('keywords', function(Blueprint $table) {
			$table->dropForeign('keywords_page_id_foreign');
		});
		Schema::table('optimizations', function(Blueprint $table) {
			$table->dropForeign('optimizations_page_id_foreign');
		});
		Schema::table('activitylogs', function(Blueprint $table) {
			$table->dropForeign('activitylogs_site_id_foreign');
		});
		Schema::table('activitylogs', function(Blueprint $table) {
			$table->dropForeign('activitylogs_page_id_foreign');
		});
	}
}