<?php

namespace App/CaseNotification;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CaseNotification extends Model 
{

    protected $table = 'case_notifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'message', 'delivery_method', 'recipient', 'sent_at', 'case_id');

    public function case()
    {
        return $this->belongsTo('Case');
    }

}