<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevenuesTable extends Migration {

	public function up()
	{
		Schema::create('revenues', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('amount', 8,2);
			$table->string('payer');
			$table->longText('description');
			$table->string('receipt_file');
			$table->enum('payment_status', array(''Paid'', ''pending'', ''overdue''));
			$table->date('due_date');
			$table->date('payment_date');
		});
	}

	public function down()
	{
		Schema::drop('revenues');
	}
}