<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('case_settings', function(Blueprint $table) {
			$table->foreign('case_status_id')->references('id')->on('case_statuses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_settings', function(Blueprint $table) {
			$table->foreign('adjournment_status_id')->references('id')->on('adjournment_statuses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_settings', function(Blueprint $table) {
			$table->foreign('case_end_reason_id')->references('id')->on('case_end_reasons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('duration_id')->references('id')->on('durations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_notifications', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_deadlines', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_deadlines', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('case_settings', function(Blueprint $table) {
			$table->dropForeign('case_settings_case_status_id_foreign');
		});
		Schema::table('case_settings', function(Blueprint $table) {
			$table->dropForeign('case_settings_adjournment_status_id_foreign');
		});
		Schema::table('case_settings', function(Blueprint $table) {
			$table->dropForeign('case_settings_case_end_reason_id_foreign');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_duration_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_plan_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_user_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_employee_id_foreign');
		});
		Schema::table('case_notifications', function(Blueprint $table) {
			$table->dropForeign('case_notifications_case_id_foreign');
		});
		Schema::table('case_deadlines', function(Blueprint $table) {
			$table->dropForeign('case_deadlines_status_id_foreign');
		});
		Schema::table('case_deadlines', function(Blueprint $table) {
			$table->dropForeign('case_deadlines_case_id_foreign');
		});
	}
}