<?php

namespace App\Models\Plan;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Plans extends Eloquent {

	protected $table = 'plans';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'case_limit', 'employee_limit', 'duration_id');

	public function duration()
	{
		return $this->hasMany('Duration');
	}

	public function subscription()
	{
		return $this->hasMany('Subscription');
	}

}