<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('amount', 8,2);
			$table->string('case_limit');
			$table->string('employee_limit');
			$table->bigInteger('duration_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}