<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecommendationsTable extends Migration {

	public function up()
	{
		Schema::create('recommendations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('patient_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->json('execise');
			$table->json('sleep');
			$table->json('supplementation');
			$table->json('water');
			$table->json('exam');
			$table->json('food_to_avoid');
			$table->json('other');
		});
	}

	public function down()
	{
		Schema::drop('recommendations');
	}
}