<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('phones', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('phones', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('email', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('email', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projets')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->foreign('tache_id')->references('id')->on('taches')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('phones', function(Blueprint $table) {
			$table->dropForeign('phones_user_id_foreign');
		});
		Schema::table('phones', function(Blueprint $table) {
			$table->dropForeign('phones_client_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_created_by_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_user_id_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_client_id_foreign');
		});
		Schema::table('email', function(Blueprint $table) {
			$table->dropForeign('email_user_id_foreign');
		});
		Schema::table('email', function(Blueprint $table) {
			$table->dropForeign('email_client_id_foreign');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->dropForeign('reporting_user_id_foreign');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->dropForeign('reporting_client_id_foreign');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->dropForeign('reporting_projet_id_foreign');
		});
		Schema::table('reporting', function(Blueprint $table) {
			$table->dropForeign('reporting_tache_id_foreign');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->dropForeign('projets_client_id_foreign');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->dropForeign('projets_created_by_foreign');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->dropForeign('taches_created_by_foreign');
		});
	}
}