<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('page_seo', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('page_section', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('page_seo', function(Blueprint $table) {
			$table->dropForeign('page_seo_page_id_foreign');
		});
		Schema::table('page_section', function(Blueprint $table) {
			$table->dropForeign('page_section_page_id_foreign');
		});
	}
}