<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfersTable extends Migration {

	public function up()
	{
		Schema::create('transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('bank_id')->unsigned();
			$table->integer('acc_id')->unsigned();
			$table->integer('pack_id')->unsigned();
			$table->smallInteger('type');
			$table->timestamp('date');
			$table->string('name', 255);
			$table->text('notes');
			$table->tinyInteger('done');
			$table->tinyInteger('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('transfers');
	}
}