<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transfer extends Eloquent {

	protected $table = 'transfers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'bank_id', 'acc_id', 'pack_id', 'type', 'date', 'name', 'notes', 'done', 'active');

	public function User()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function Bank()
	{
		return $this->belongsTo('App\Bank', 'bank_id');
	}

	public function Accounts()
	{
		return $this->hasMany('App\Account', 'account_id');
	}

	public function Pack()
	{
		return $this->belongsTo('App\Pack', 'back_id');
	}

}