<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Flight extends Model 
{

    protected $table = 'flights';
    public $timestamps = true;

    public function rel1()
    {
        return $this->belongsTo('Airline', 'airline_id');
    }

    public function rel2()
    {
        return $this->belongsTo('Airplane', 'airplane_id');
    }

    public function origin()
    {
        return $this->hasOne('Airport', 'origin_airport_id');
    }

    public function destination()
    {
        return $this->hasOne('Airport', 'destination_airport_id');
    }

}