<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAirplaneModelsTable extends Migration {

	public function up()
	{
		Schema::create('airplane_models', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 60);
			$table->string('shortname', 4)->unique();
			$table->smallInteger('seats_capacity');
			$table->integer('cargo_capacity');
			$table->smallInteger('range');
			$table->smallInteger('speed');
			$table->float('fuel_usage');
			$table->integer('price');
			$table->tinyInteger('cabin_crew');
			$table->smallInteger('min_runway_length');
			$table->string('manufacturer', 25);
			$table->smallInteger('introduction_year');
		});
	}

	public function down()
	{
		Schema::drop('airplane_models');
	}
}