<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAirplanesTable extends Migration {

	public function up()
	{
		Schema::create('airplanes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('airplane_model_id')->unsigned();
			$table->integer('airline_id')->unsigned();
			$table->integer('base_airport_id')->unsigned();
			$table->date('built');
			$table->string('registration', 8);
			$table->datetime('last_maintenance_service');
		});
	}

	public function down()
	{
		Schema::drop('airplanes');
	}
}