<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAirportsTable extends Migration {

	public function up()
	{
		Schema::create('airports', function(Blueprint $table) {
			$table->increments('id');
			$table->string('iata_code', 4)->unique();
			$table->string('name');
			$table->string('country', 3);
			$table->smallInteger('slots_per_hour');
			$table->smallInteger('runway_length');
			$table->boolean('night_operations')->default(0);
			$table->float('lat', 10,8);
			$table->float('lng', 10,8);
		});
	}

	public function down()
	{
		Schema::drop('airports');
	}
}