<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlightsTable extends Migration {

	public function up()
	{
		Schema::create('flights', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('airline_id')->unsigned();
			$table->integer('airplane_id')->unsigned();
			$table->integer('origin_airport_id')->unsigned();
			$table->integer('destination_airport_id')->unsigned();
			$table->smallInteger('distance');
			$table->datetime('departure_time');
			$table->datetime('arrival_time');
			$table->smallInteger('delay');
			$table->string('flight_number', 6);
			$table->boolean('has_arrived');
			$table->smallInteger('passengers_economy');
			$table->smallInteger('passengers_business');
			$table->smallInteger('passengers_firstclass');
			$table->integer('cargo');
		});
	}

	public function down()
	{
		Schema::drop('flights');
	}
}