<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('airlines', function(Blueprint $table) {
			$table->foreign('headquarters_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('airplanes', function(Blueprint $table) {
			$table->foreign('airplane_model_id')->references('id')->on('airplane_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('airplanes', function(Blueprint $table) {
			$table->foreign('airline_id')->references('id')->on('airlines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('airplanes', function(Blueprint $table) {
			$table->foreign('base_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('airline_id')->references('id')->on('airlines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('airplane_id')->references('id')->on('airplanes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('origin_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->foreign('destination_airport_id')->references('id')->on('airports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('airlines', function(Blueprint $table) {
			$table->dropForeign('airlines_headquarters_airport_id_foreign');
		});
		Schema::table('airplanes', function(Blueprint $table) {
			$table->dropForeign('airplanes_airplane_model_id_foreign');
		});
		Schema::table('airplanes', function(Blueprint $table) {
			$table->dropForeign('airplanes_airline_id_foreign');
		});
		Schema::table('airplanes', function(Blueprint $table) {
			$table->dropForeign('airplanes_base_airport_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_airline_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_airplane_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_origin_airport_id_foreign');
		});
		Schema::table('flights', function(Blueprint $table) {
			$table->dropForeign('flights_destination_airport_id_foreign');
		});
	}
}