<?php

use Illuminate\Database\Seeder;
use \Airport;

class AirportTableSeeder extends Seeder {

	public function run()
	{
		//DB::table('airports')->delete();

		// waw
		Airport::create(array(
				'iata_code' => 'waw',
				'name' => 'Warsaw Chopin Airport',
				'country' => 'pl',
				'slots_per_hour' => 25,
				'lat' => '52.165833',
				'lng' => '20.967222',
				'runway_length' => 3600
			));

		// krk
		Airport::create(array(
				'iata_code' => 'krk',
				'name' => 'Kraków Balice',
				'country' => 'pl',
				'slots_per_hour' => 15,
				'lat' => '50.077778',
				'lng' => '19.784722',
				'runway_length' => 2550
			));

		// ktw
		Airport::create(array(
				'iata_code' => 'ktw',
				'name' => 'Katowice Pyrzowice',
				'country' => 'pl',
				'slots_per_hour' => 5,
				'lat' => '50.474167',
				'lng' => '19.08',
				'runway_length' => 3200
			));

		// fra
		Airport::create(array(
				'iata_code' => 'fra',
				'name' => 'Frankfurt',
				'country' => 'de',
				'slots_per_hour' => 40,
				'lat' => '50.026422',
				'lng' => '8.543125',
				'runway_length' => 4000
			));

		// lhr
		Airport::create(array(
				'iata_code' => 'lhr',
				'name' => 'London Heathrow',
				'country' => 'gb',
				'slots_per_hour' => 45,
				'lat' => '51.470833',
				'lng' => '-0.460556',
				'runway_length' => 3900
			));
	}
}