<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserPointsTable extends Migration {

	public function up()
	{
		Schema::create('user_points', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->smallInteger('point_type')->unsigned();
			$table->integer('creditor')->unsigned()->nullable()->default('0');
			$table->integer('deptor')->unsigned()->default('0');
			$table->string('info')->nullable();
			$table->text('meta')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_points');
	}
}