<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpotTable extends Migration {

	public function up()
	{
		Schema::create('spot', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 200);
			$table->float('lat');
			$table->float('long');
			$table->integer('userID');
			$table->integer('status_level');
			$table->string('type', 30)->default('NOIVA');
		});
	}

	public function down()
	{
		Schema::drop('spot');
	}
}