<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFeesPaidTable extends Migration {

	public function up()
	{
		Schema::create('fees_paid', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('app_fees');
			$table->decimal('fees_paid');
			$table->decimal('remaining_fees');
			$table->enum('payment_method', array('cash_on_delivery', 'pay_online'));
			$table->datetime('payment_date');
			$table->enum('status', array('0', '1'));
			$table->longText('notes');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fees_paid');
	}
}