<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('msgserver', function(Blueprint $table) {
			$table->foreign('domain_id')->references('id')->on('server')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('msgserver', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('lang')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('msgserver', function(Blueprint $table) {
			$table->dropForeign('msgserver_domain_id_foreign');
		});
		Schema::table('msgserver', function(Blueprint $table) {
			$table->dropForeign('msgserver_lang_id_foreign');
		});
	}
}