<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingProvidersTable extends Migration {

	public function up()
	{
		Schema::create('setting_providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('provider_id')->unsigned();
			$table->string('profit_rate', 10);
			$table->integer('maximum_repayment_period');
			$table->integer('minimum_repayment_period');
			$table->string('maximum_invoice_pay', 20);
			$table->string('minimum_invoice_pay', 20);
		});
	}

	public function down()
	{
		Schema::drop('setting_providers');
	}
}