<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->text('detail');
			$table->timestamp('created_at');
			$table->integer('status');
			$table->integer('client_id')->unsigned()->nullable();
			$table->integer('provider_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}