<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCargoFirmsIntegrationTable extends Migration {

	public function up()
	{
		Schema::create('cargo_firms_integration', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('cargo_firm_id');
			$table->string('type');
			$table->text('data');
			$table->tinyInteger('is_system_defined');
			$table->tinyInteger('is_default');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cargo_firms_integration');
	}
}