<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderRequestsTable extends Migration {

	public function up()
	{
		Schema::create('order_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('cargo_firm_integration_id');
			$table->string('builder');
			$table->string('resolver');
			$table->text('request');
			$table->text('response');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_requests');
	}
}