<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliationSettingsTable extends Migration {

	public function up()
	{
		Schema::create('affiliation_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('is_active')->default(true);
			$table->boolean('is_renewal')->default(true);
			$table->double('commission')->nullable();
			$table->double('cookie_expiration')->nullable();
			$table->double('minimum_withdrawal')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('affiliation_settings');
	}
}